/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AbstractMapEntry;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.LinkedHashMultiset;
import org.python.google.common.collect.ListMultimap;
import org.python.google.common.collect.Lists;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.Multimap;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.Multisets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedListMultimap<K, V>
implements ListMultimap<K, V>,
Serializable {
    private transient Node<K, V> head;
    private transient Node<K, V> tail;
    private transient Multiset<K> keyCount;
    private transient Map<K, Node<K, V>> keyToKeyHead;
    private transient Map<K, Node<K, V>> keyToKeyTail;
    private transient Set<K> keySet;
    private transient Multiset<K> keys;
    private transient Collection<V> valuesCollection;
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Map<K, Collection<V>> map;
    @GwtIncompatible(value="java serialization not supported")
    private static final long serialVersionUID = 0L;

    public static <K, V> LinkedListMultimap<K, V> create() {
        return new LinkedListMultimap<K, V>();
    }

    public static <K, V> LinkedListMultimap<K, V> create(int n) {
        return new LinkedListMultimap<K, V>(n);
    }

    public static <K, V> LinkedListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedListMultimap<K, V>(multimap);
    }

    private LinkedListMultimap() {
        this.keyCount = LinkedHashMultiset.create();
        this.keyToKeyHead = Maps.newHashMap();
        this.keyToKeyTail = Maps.newHashMap();
    }

    private LinkedListMultimap(int n) {
        this.keyCount = LinkedHashMultiset.create(n);
        this.keyToKeyHead = Maps.newHashMapWithExpectedSize(n);
        this.keyToKeyTail = Maps.newHashMapWithExpectedSize(n);
    }

    private LinkedListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size());
        this.putAll(multimap);
    }

    private Node<K, V> addNode(@Nullable K k, @Nullable V v, @Nullable Node<K, V> node) {
        Node<K, V> node2 = new Node<K, V>(k, v);
        if (this.head == null) {
            this.tail = node2;
            this.head = this.tail;
            this.keyToKeyHead.put(k, node2);
            this.keyToKeyTail.put(k, node2);
        } else if (node == null) {
            this.tail.next = node2;
            node2.previous = this.tail;
            Node<K, V> node3 = this.keyToKeyTail.get(k);
            if (node3 == null) {
                this.keyToKeyHead.put(k, node2);
            } else {
                node3.nextSibling = node2;
                node2.previousSibling = node3;
            }
            this.keyToKeyTail.put(k, node2);
            this.tail = node2;
        } else {
            node2.previous = node.previous;
            node2.previousSibling = node.previousSibling;
            node2.next = node;
            node2.nextSibling = node;
            if (node.previousSibling == null) {
                this.keyToKeyHead.put(k, node2);
            } else {
                node.previousSibling.nextSibling = node2;
            }
            if (node.previous == null) {
                this.head = node2;
            } else {
                node.previous.next = node2;
            }
            node.previous = node2;
            node.previousSibling = node2;
        }
        this.keyCount.add(k);
        return node2;
    }

    private void removeNode(Node<K, V> node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.tail = node.previous;
        }
        if (node.previousSibling != null) {
            node.previousSibling.nextSibling = node.nextSibling;
        } else if (node.nextSibling != null) {
            this.keyToKeyHead.put(node.key, node.nextSibling);
        } else {
            this.keyToKeyHead.remove(node.key);
        }
        if (node.nextSibling != null) {
            node.nextSibling.previousSibling = node.previousSibling;
        } else if (node.previousSibling != null) {
            this.keyToKeyTail.put(node.key, node.previousSibling);
        } else {
            this.keyToKeyTail.remove(node.key);
        }
        this.keyCount.remove(node.key);
    }

    private void removeAllNodes(@Nullable Object object) {
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(object);
        while (valueForKeyIterator.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.remove();
        }
    }

    private static void checkElement(@Nullable Object object) {
        if (object == null) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int size() {
        return this.keyCount.size();
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.keyToKeyHead.containsKey(object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        NodeIterator nodeIterator = new NodeIterator();
        while (nodeIterator.hasNext()) {
            if (!Objects.equal(((Node)nodeIterator.next()).value, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object object, @Nullable Object object2) {
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(object);
        while (valueForKeyIterator.hasNext()) {
            if (!Objects.equal(valueForKeyIterator.next(), object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean put(@Nullable K k, @Nullable V v) {
        this.addNode(k, v, null);
        return true;
    }

    @Override
    public boolean remove(@Nullable Object object, @Nullable Object object2) {
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(object);
        while (valueForKeyIterator.hasNext()) {
            if (!Objects.equal(valueForKeyIterator.next(), object2)) continue;
            valueForKeyIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean putAll(@Nullable K k, Iterable<? extends V> iterable) {
        boolean bl = false;
        for (V v : iterable) {
            bl |= this.put(k, v);
        }
        return bl;
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean bl = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            bl |= this.put(entry.getKey(), entry.getValue());
        }
        return bl;
    }

    @Override
    public List<V> replaceValues(@Nullable K k, Iterable<? extends V> iterable) {
        List<V> list = this.getCopy(k);
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(k);
        Iterator<V> iterator = iterable.iterator();
        while (valueForKeyIterator.hasNext() && iterator.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.set(iterator.next());
        }
        while (valueForKeyIterator.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.remove();
        }
        while (iterator.hasNext()) {
            valueForKeyIterator.add(iterator.next());
        }
        return list;
    }

    private List<V> getCopy(@Nullable Object object) {
        return Collections.unmodifiableList(Lists.newArrayList(new ValueForKeyIterator(object)));
    }

    @Override
    public List<V> removeAll(@Nullable Object object) {
        List<V> list = this.getCopy(object);
        this.removeAllNodes(object);
        return list;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.keyCount.clear();
        this.keyToKeyHead.clear();
        this.keyToKeyTail.clear();
    }

    @Override
    public List<V> get(final @Nullable K k) {
        return new AbstractSequentialList<V>(){

            @Override
            public int size() {
                return LinkedListMultimap.this.keyCount.count(k);
            }

            @Override
            public ListIterator<V> listIterator(int n) {
                return new ValueForKeyIterator(k, n);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return Iterators.removeAll(this.iterator(), collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return Iterators.retainAll(this.iterator(), collection);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        AbstractSet abstractSet = this.keySet;
        if (abstractSet == null) {
            this.keySet = abstractSet = new AbstractSet<K>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.elementSet().size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new DistinctKeyIterator();
                }

                @Override
                public boolean contains(Object object) {
                    return LinkedListMultimap.this.keyCount.contains(object);
                }

                @Override
                public boolean removeAll(Collection<?> collection) {
                    Preconditions.checkNotNull(collection);
                    return super.removeAll(collection);
                }
            };
        }
        return abstractSet;
    }

    @Override
    public Multiset<K> keys() {
        MultisetView multisetView = this.keys;
        if (multisetView == null) {
            this.keys = multisetView = new MultisetView();
        }
        return multisetView;
    }

    @Override
    public Collection<V> values() {
        AbstractCollection abstractCollection = this.valuesCollection;
        if (abstractCollection == null) {
            this.valuesCollection = abstractCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.size();
                }

                @Override
                public Iterator<V> iterator() {
                    final NodeIterator nodeIterator = new NodeIterator();
                    return new Iterator<V>(){

                        @Override
                        public boolean hasNext() {
                            return nodeIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return ((Node)nodeIterator.next()).value;
                        }

                        @Override
                        public void remove() {
                            nodeIterator.remove();
                        }
                    };
                }
            };
        }
        return abstractCollection;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        AbstractCollection abstractCollection = this.entries;
        if (abstractCollection == null) {
            this.entries = abstractCollection = new AbstractCollection<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.size();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final NodeIterator nodeIterator = new NodeIterator();
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return nodeIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            final Node node = (Node)nodeIterator.next();
                            return new AbstractMapEntry<K, V>(){

                                @Override
                                public K getKey() {
                                    return node.key;
                                }

                                @Override
                                public V getValue() {
                                    return node.value;
                                }

                                @Override
                                public V setValue(V v) {
                                    Object v2 = node.value;
                                    node.value = v;
                                    return v2;
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            nodeIterator.remove();
                        }
                    };
                }
            };
        }
        return abstractCollection;
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        AbstractMap abstractMap = this.map;
        if (abstractMap == null) {
            this.map = abstractMap = new AbstractMap<K, Collection<V>>(){
                Set<Map.Entry<K, Collection<V>>> entrySet;

                @Override
                public Set<Map.Entry<K, Collection<V>>> entrySet() {
                    AsMapEntries asMapEntries = this.entrySet;
                    if (asMapEntries == null) {
                        this.entrySet = asMapEntries = new AsMapEntries();
                    }
                    return asMapEntries;
                }

                @Override
                public boolean containsKey(@Nullable Object object) {
                    return LinkedListMultimap.this.containsKey(object);
                }

                @Override
                public Collection<V> get(@Nullable Object object) {
                    Collection collection = LinkedListMultimap.this.get(object);
                    return collection.isEmpty() ? null : collection;
                }

                @Override
                public Collection<V> remove(@Nullable Object object) {
                    Collection collection = LinkedListMultimap.this.removeAll(object);
                    return collection.isEmpty() ? null : collection;
                }
            };
        }
        return abstractMap;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap multimap = (Multimap)object;
            return ((Object)this.asMap()).equals(multimap.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.asMap()).hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Map.Entry<K, V> entry : this.entries()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keyCount = LinkedHashMultiset.create();
        this.keyToKeyHead = Maps.newHashMap();
        this.keyToKeyTail = Maps.newHashMap();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMapEntries
    extends AbstractSet<Map.Entry<K, Collection<V>>> {
        private AsMapEntries() {
        }

        @Override
        public int size() {
            return LinkedListMultimap.this.keyCount.elementSet().size();
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            final DistinctKeyIterator distinctKeyIterator = new DistinctKeyIterator();
            return new Iterator<Map.Entry<K, Collection<V>>>(){

                @Override
                public boolean hasNext() {
                    return distinctKeyIterator.hasNext();
                }

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    final Object e = distinctKeyIterator.next();
                    return new AbstractMapEntry<K, Collection<V>>(){

                        @Override
                        public K getKey() {
                            return e;
                        }

                        @Override
                        public Collection<V> getValue() {
                            return LinkedListMultimap.this.get(e);
                        }
                    };
                }

                @Override
                public void remove() {
                    distinctKeyIterator.remove();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistinctKeyIterator
    implements Iterator<K> {
        final Set<K> seenKeys;
        Node<K, V> next;
        Node<K, V> current;

        private DistinctKeyIterator() {
            this.seenKeys = new HashSet(Maps.capacity(LinkedListMultimap.this.keySet().size()));
            this.next = LinkedListMultimap.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public K next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.seenKeys.add(this.current.key);
            do {
                this.next = this.next.next;
            } while (this.next != null && !this.seenKeys.add(this.next.key));
            return this.current.key;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            LinkedListMultimap.this.removeAllNodes(this.current.key);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetView
    extends AbstractCollection<K>
    implements Multiset<K> {
        private MultisetView() {
        }

        @Override
        public int size() {
            return LinkedListMultimap.this.keyCount.size();
        }

        @Override
        public Iterator<K> iterator() {
            final NodeIterator nodeIterator = new NodeIterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return nodeIterator.hasNext();
                }

                @Override
                public K next() {
                    return ((Node)nodeIterator.next()).key;
                }

                @Override
                public void remove() {
                    nodeIterator.remove();
                }
            };
        }

        @Override
        public int count(@Nullable Object object) {
            return LinkedListMultimap.this.keyCount.count(object);
        }

        @Override
        public int add(@Nullable K k, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(@Nullable Object object, int n) {
            Preconditions.checkArgument(n >= 0);
            int n2 = this.count(object);
            ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(object);
            while (n-- > 0 && valueForKeyIterator.hasNext()) {
                valueForKeyIterator.next();
                valueForKeyIterator.remove();
            }
            return n2;
        }

        @Override
        public int setCount(K k, int n) {
            return Multisets.setCountImpl(this, k, n);
        }

        @Override
        public boolean setCount(K k, int n, int n2) {
            return Multisets.setCountImpl(this, k, n, n2);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return Iterators.removeAll(this.iterator(), collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return Iterators.retainAll(this.iterator(), collection);
        }

        @Override
        public Set<K> elementSet() {
            return LinkedListMultimap.this.keySet();
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            return new AbstractSet<Multiset.Entry<K>>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.elementSet().size();
                }

                @Override
                public Iterator<Multiset.Entry<K>> iterator() {
                    final DistinctKeyIterator distinctKeyIterator = new DistinctKeyIterator();
                    return new Iterator<Multiset.Entry<K>>(){

                        @Override
                        public boolean hasNext() {
                            return distinctKeyIterator.hasNext();
                        }

                        @Override
                        public Multiset.Entry<K> next() {
                            final Object e = distinctKeyIterator.next();
                            return new Multisets.AbstractEntry<K>(){

                                @Override
                                public K getElement() {
                                    return e;
                                }

                                @Override
                                public int getCount() {
                                    return LinkedListMultimap.this.keyCount.count(e);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            distinctKeyIterator.remove();
                        }
                    };
                }
            };
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return ((Object)LinkedListMultimap.this.keyCount).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)LinkedListMultimap.this.keyCount).hashCode();
        }

        @Override
        public String toString() {
            return ((Object)LinkedListMultimap.this.keyCount).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node<K, V> {
        final K key;
        V value;
        Node<K, V> next;
        Node<K, V> previous;
        Node<K, V> nextSibling;
        Node<K, V> previousSibling;

        Node(@Nullable K k, @Nullable V v) {
            this.key = k;
            this.value = v;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeIterator
    implements Iterator<Node<K, V>> {
        Node<K, V> next;
        Node<K, V> current;

        private NodeIterator() {
            this.next = LinkedListMultimap.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node<K, V> next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.next = this.next.next;
            return this.current;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueForKeyIterator
    implements ListIterator<V> {
        final Object key;
        int nextIndex;
        Node<K, V> next;
        Node<K, V> current;
        Node<K, V> previous;

        ValueForKeyIterator(Object object) {
            this.key = object;
            this.next = (Node)LinkedListMultimap.this.keyToKeyHead.get(object);
        }

        public ValueForKeyIterator(Object object, int n) {
            int n2 = LinkedListMultimap.this.keyCount.count(object);
            Preconditions.checkPositionIndex(n, n2);
            if (n >= n2 / 2) {
                this.previous = (Node)LinkedListMultimap.this.keyToKeyTail.get(object);
                this.nextIndex = n2;
                while (n++ < n2) {
                    this.previous();
                }
            } else {
                this.next = (Node)LinkedListMultimap.this.keyToKeyHead.get(object);
                while (n-- > 0) {
                    this.next();
                }
            }
            this.key = object;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.nextSibling;
            ++this.nextIndex;
            return this.current.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public V previous() {
            LinkedListMultimap.checkElement(this.previous);
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previousSibling;
            --this.nextIndex;
            return this.current.value;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            if (this.current != this.next) {
                this.previous = this.current.previousSibling;
                --this.nextIndex;
            } else {
                this.next = this.current.nextSibling;
            }
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
        }

        @Override
        public void set(V v) {
            Preconditions.checkState(this.current != null);
            this.current.value = v;
        }

        @Override
        public void add(V v) {
            this.previous = LinkedListMultimap.this.addNode(this.key, v, this.next);
            ++this.nextIndex;
            this.current = null;
        }
    }
}

